<?php
echo $this->Form->create('Install', array(
    'url'           => array(
        'controller' => 'install',
        'action'     => 'database'
    ),
    'inputDefaults' => array(
        'label' => false,
        'div'   => false,
        'class' => 'form-control placeholder-no-fix',
        'error' => array(
            'attributes' => array( 'wrap' => 'span', 'class' => 'help-block' )
        )
    ) ));
?>
<div class="install">
    <div class="page-header">
        <h2><?php echo $title_for_layout; ?></h2>
    </div>

    <?php if ($currentConfiguration[ 'exists' ]) : ?>
        <div class="alert alert-warning">
            <strong><?php echo __('Warning'); ?>:</strong>
            <?php echo __('A `database.php` file already exists.'); ?>
            <?php
            if ($currentConfiguration[ 'valid' ]) :
                $valid = __('Valid');
                $class = 'text-success';
            else :
                $valid = __('Invalid');
                $class = 'text-error';
            endif;
            echo __('This file is %s.', $this->Html->tag('span', $valid, compact('class')));
            ?>
            <?php if ($currentConfiguration[ 'valid' ]) : ?>
                <?php
                echo $this->Html->link(
                    __('Reuse this file and proceed.'),
                    array( 'action' => 'data' ),
                    array( 'class' => 'alert-link' )
                );
                ?>
            <?php else : ?>
                <?php echo __('This file will be replaced.'); ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php
    /*
      echo $this->Form->input( 'datasource', array(
      'placeholder' => __( 'Database' ),
      'default'     => 'Database/Mysql',
      'empty'       => false,
      'options'     => array(
      'Database/Mysql'     => 'mysql',
      'Database/Sqlite'    => 'sqlite',
      'Database/Postgres'  => 'postgres',
      'Database/Sqlserver' => 'mssql',
      ),
      ) );
     */
    ?>

    <div class="form-group <?php echo($this->Form->isFieldError('host') ? 'has-error' : ''); ?>">
        <label class="control-label" for="host">Database Host URL</label>
        <?php echo $this->Form->input('host', array( 'default' => 'localhost' )); ?>
    </div>

    <div class="form-group <?php echo($this->Form->isFieldError('login') ? 'has-error' : ''); ?>">
        <label class="control-label" for="login">Database Username</label>
        <?php echo $this->Form->input('login'); ?>
    </div>

    <div class="form-group <?php echo($this->Form->isFieldError('password') ? 'has-error' : ''); ?>">
        <label class="control-label" for="password">Database Username Password</label>
        <?php echo $this->Form->input('password'); ?>
    </div>

    <div class="form-group <?php echo($this->Form->isFieldError('database') ? 'has-error' : ''); ?>">
        <label class="control-label" for="host">Database Name</label>
        <?php echo $this->Form->input('database'); ?>
    </div>
    <?php
    /*
      echo $this->Form->input( 'prefix', array(
      'placeholder' => __( 'Prefix' )
      ) );
      echo $this->Form->input( 'port', array(
      'placeholder' => __( 'Port' ),
      'default'     => '3306'
      ) );
     */
    ?>
</div>
<div class="form-actions">
    <?php echo $this->Form->end(array( 'label' => 'Submit', 'class' => 'btn btn-success' )); ?>
</div>